/**********************************************************************
*	Bastion Products Copyright 1998								*
*	All rights reserved										*
*	This source is freely distributable in an unmodified state.		*
*	Last Modified:	5/20/98									*
*	Author:			Jennifer Weston							*
***********************************************************************/

#ifndef _BLITHE_CONST_H_
#define _BLITHE_CONST_H_

// Message received by all apps when the language is changed globally
#define BLITHE_UPDATE_LANGUAGE 'BLUL'

// Message received by the target when the language menu is changed locally
#define BLITHE_LANGUAGE_CHANGED 'BLLC'

// Message received by the application when the application dictionary is not present
#define BLITHE_NO_APP_DICTIONARY 'BLNO'

/*
**	Language Declarations
*/
#define BL_APP_LANGUAGE -1
#define BL_DEFAULT_LANGUAGE 0
#define BL_AFAR_LANGUAGE 'aar\0'
#define BL_ABKHAZIAN_LANGUAGE 'abk\0'
#define BL_ACHINESE_LANGUAGE 'ace\0'
#define BL_ACOLI_LANGUAGE 'ach\0'
#define BL_ADANGME_LANGUAGE 'ada\0'
#define BL_AFRIHILI_LANGUAGE 'afh\0'
#define BL_AFRIKAANS_LANGUAGE 'afr\0'
#define BL_ALJAMIA_LANGUAGE 'ajm\0'
#define BL_AKAN_LANGUAGE 'aka\0'
#define BL_AKKADIAN_LANGUAGE 'akk\0'
#define BL_ALEUT_LANGUAGE 'ale\0'
#define BL_AMHARIC_LANGUAGE 'amh\0'
#define BL_ARABIC_LANGUAGE 'ara\0'
#define BL_ARAMAIC_LANGUAGE 'arc\0'
#define BL_ARAUCANIAN_LANGUAGE 'arn\0'
#define BL_ARAPAHO_LANGUAGE 'arp\0'
#define BL_ARAWAK_LANGUAGE 'arw\0'
#define BL_ASSAMESE_LANGUAGE 'asm\0'
#define BL_AVARIC_LANGUAGE 'ava\0'
#define BL_AVESTAN_LANGUAGE 'ave\0'
#define BL_AWADHI_LANGUAGE 'awa\0'
#define BL_AYMARA_LANGUAGE 'aym\0'
#define BL_AZERBAIJANI_LANGUAGE 'aze\0'
#define BL_BANDA_LANGUAGE 'bad\0'
#define BL_BASHKIR_LANGUAGE 'bak\0'
#define BL_BALUCHI_LANGUAGE 'bal\0'
#define BL_BAMBARA_LANGUAGE 'bam\0'
#define BL_BALINESE_LANGUAGE 'ban\0'
#define BL_BASA_LANGUAGE 'bas\0'
#define BL_BEJA_LANGUAGE 'bej\0'
#define BL_BELARUSIAN_LANGUAGE 'bel\0'
#define BL_BEMBA_LANGUAGE 'bem\0'
#define BL_BENGALI_LANGUAGE 'ben\0'
#define BL_BHOJPURI_LANGUAGE 'bho\0'
#define BL_BIHARI_LANGUAGE 'bih\0'
#define BL_BIKOL_LANAGUAGE 'bik\0'
#define BL_BINI_LANGUAGE 'bin\0'
#define BL_BISLAMA_LANGUAGE 'bis\0'
#define BL_SIKSIKA_LANGUAGE 'bla\0'
#define BL_TIBETAN_LANGUAGE 'bod\0'
#define BL_BRAJ_LANGUAGE 'bra\0'
#define BL_BRETON_LANGUAGE 'bre\0'
#define BL_BATAK_LANGUAGE 'btk\0'
#define BL_BURIAT_LANGUAGE 'bua\0'
#define BL_BUGINESE_LANGUAGE 'bug\0'
#define BL_BULGARIAN_LANGUAGE 'bul\0'
#define BL_CADDO_LANGUAGE 'cad\0'
#define BL_CARIB_LANGUAGE 'car\0'
#define BL_CATALAN_LANGUAGE 'cat\0'
#define BL_CEBUANO_LANGUAGE 'ceb\0'
#define BL_CZECH_LANGUAGE 'ces\0'
#define BL_CHAMORRO_LANGUAGE 'cha\0'
#define BL_CHIBCHA_LANGUAGE 'chb\0'
#define BL_CHECHEN_LANGUAGE 'che\0'
#define BL_CHAGATAI_LANGUAGE 'chg\0'
#define BL_CHUUKESE_LANGUAGE 'chk\0'
#define BL_MARI_LANGUAGE 'chm\0'
#define BL_CHOCTAW_LANGUAGE 'cho\0'
#define BL_CHIPEWYAN_LANGUAGE 'chp\0'
#define BL_CHUVASH_LANGUAGE 'chv\0'
#define BL_COPTIC_LANGUAGE 'cop\0'
#define BL_CORNISH_LANGUAGE 'cor\0'
#define BL_CORSICAN_LANGUAGE 'cos\0'
#define BL_CREOLES_ENGLISH_LANGUAGE 'cpe\0'
#define BL_CREOLES_FRENCH_LANGUAGE 'cpf\0'
#define BL_CREOLES_PORTUGUESE_LANGUAGE 'cpp\0'
#define BL_CREE_LANGUAGE 'cre\0'
#define BL_CREOLE_LANGUAGE 'crp\0'
#define BL_WELSH_LANGUAGE 'cym\0'
#define BL_DAKOTA_LANGUAGE 'dak\0'
#define BL_DANISH_LANGUAGE 'dan\0'
#define BL_DAYAK_LANGUAGE 'day\0'
#define BL_SLAVE_LANGUAGE 'den\0'
#define BL_ATHAPASCAN_LANGUAGE 'den\0'
#define BL_GERMAN_LANGUAGE 'deu\0'
#define BL_DOGRIB_LANGUAGE 'dgr\0'
#define BL_DINKA_LANGUAGE 'din\0'
#define BL_DIVEHI_LANGUAGE 'div\0'
#define BL_DOGRI_LANGUAGE 'doi\0'
#define BL_DUALA_LANGUAGE 'dua\0'
#define BL_DYULA_LANGUAGE 'dyu\0'
#define BL_DZONGKHA_LANGUAGE 'dzo\0'
#define BL_EFIK_LANGUAGE 'efi\0'
#define BL_EKAJUK_LANGUAGE 'eka\0'
#define BL_GREEK_LANGUAGE 'ell\0'
#define BL_ELAMITE_LANGUAGE 'elx\0'
#define BL_ENGLISH_LANGUAGE 'eng\0'
#define BL_AMERICAN_ENGLISH_LANGUAGE 'eng\0'
#define BL_ESPERANTO_LANGUAGE 'epo\0'
#define BL_ESTONIAN_LANGUAGE 'est\0'
#define BL_ETHIOPIC_LANGUAGE 'eth\0'
#define BL_BASQUE_LANGUAGE 'eus\0'
#define BL_EWE_LANGUAGE 'ewe\0'
#define BL_EWONDO_LANGUAGE 'ewo\0'
#define BL_FANG_LANGUAGE 'fan\0'
#define BL_FAROESE_LANGUAGE 'fao\0'
#define BL_PERSIAN_LANGUAGE 'fas\0'
#define BL_FANTI_LANGUAGE 'fat\0'
#define BL_FIJIAN_LANGUAGE 'fij\0'
#define BL_FINNISH_LANGUAGE 'fin\0'
#define BL_FON_LANGUAGE 'fon\0'
#define BL_FRENCH_LANGUAGE 'fra\0'
#define BL_FRISIAN_LANGUAGE 'fry\0'
#define BL_FULAH_LANGUAGE 'ful\0'
#define BL_FRIULIAN_LANGUAGE 'fur\0'
#define BL_GA_LANGUAGE 'gaa\0'
#define BL_IRISH_LANGUAGE 'gai\0'
#define BL_GAYO_LANGUAGE 'gay\0'
#define BL_GBAYA_LANGUAGE 'gba\0'
#define BL_GAELIC_SCOTS_LANGUAGE 'gdh\0'
#define BL_GEEZ_LANGUAGE 'gez\0'
#define BL_GILBERTESE_LANGUAGE 'gil\0'
#define BL_GALLEGAN_LANGUAGE 'glg\0'
#define BL_GONDI_LANGUAGE 'gon\0'
#define BL_GORONTALO_LANGUAGE 'gor\0'
#define BL_GOTHIC_LANGUAGE 'got\0'
#define BL_GREBO_LANGUAGE 'grb\0'
#define BL_GUARANI_LANGUAGE 'grn\0'
#define BL_GUJARATI_LANGUAGE 'guj\0'
#define BL_GWICHIN_LANGUAGE 'gwi\0'
#define BL_HAIDA_LANGUAGE 'hai\0'
#define BL_HAUSA_LANGUAGE 'hau\0'
#define BL_HAWAIIAN_LANGUAGE 'haw\0'
#define BL_HEBREW_LANGUAGE 'heb\0'
#define BL_HERERO_LANGUAGE 'her\0'
#define BL_HILIGAYNON_LANGUAGE 'hil\0'
#define BL_HIMACHALI_LANGUAGE 'him\0'
#define BL_HINDI_LANGUAGE 'hin\0'
#define BL_HITTITE_LANGUAGE 'hit\0'
#define BL_HMONG_LANGUAGE 'hmn\0'
#define BL_HIRI_MOTU_LANGUAGE 'hmo\0'
#define BL_CROATIAN_LANGUAGE 'hrv\0'
#define BL_HUNGARIAN_LANGUAGE 'hun\0'
#define BL_HUPA_LANGUAGE 'hup\0'
#define BL_ARMENIAN_LANGUAGE 'hye\0'
#define BL_IBAN_LANGUAGE 'iba\0'
#define BL_IGBO_LANGUAGE 'ibo\0'
#define BL_IJO_LANGUAGE 'ijo\0'
#define BL_INUKTITUT_LAGNUAGE 'iku\0'
#define BL_INTERLINGUE_LANGUAGE 'ile\0'
#define BL_ILOKO_LANGUAGE 'ilo\0'
#define BL_INTERLINGUA_LANGUAGE 'ina\0'
#define BL_INDONESIAN_LANGUAGE 'ind\0'
#define BL_INUPIAK_LANGUAGE 'ipk\0'
#define BL_ICELANDIC_LANGUAGE 'isl\0'
#define BL_ITALIAN_LANGUAGE 'ita\0'
#define BL_JAVANESE_LANGUAGE 'jaw\0'
#define BL_JAPANESE_LANGUAGE 'jpn\0'
#define BL_JUDEO_PERSIAN_LANGUAGE 'jpr\0'
#define BL_JUDEO_ARABIC_LANGUAGE 'jrb\0'
#define BL_KARA_KALPAK_LANGUAGE 'kaa\0'
#define BL_KABYLE_LANGUAGE 'kab\0'
#define BL_KACHIN_LANGUAGE 'kac\0'
#define BL_KALAALLISUT_LANGUAGE 'kal\0'
#define BL_KAMBA_LANGUAGE 'kam\0'
#define BL_KANNADA_LANGUAGE 'kan\0'
#define BL_KAREN_LANGUAGE 'kar\0'
#define BL_KASHMIRI_LANGUAGE 'kas\0'
#define BL_GEORGIAN_LANGUAGE 'kat\0'
#define BL_KANURI_LANGUAGE 'kau\0'
#define BL_KAWI_LANGUAGE 'kaw\0'
#define BL_KAZAKH_LANGUAGE 'kaz\0'
#define BL_KHASI_LANGUAGE 'kha\0'
#define BL_KHMER_LANGUAGE 'khm\0'
#define BL_KHOTANESE_LANGUAGE 'kho\0'
#define BL_KIKUYU_LANGUAGE 'kik\0'
#define BL_KINYARWANDA_LANGUAGE 'kin\0'
#define BL_KIRGHIZ_LANGUAGE 'kir\0'
#define BL_KIMBUNDU_LANGUAGE 'kmb\0'
#define BL_KONKANI_LANGUAGE 'kok\0'
#define BL_KOMI_LANGUAGE 'kom\0'
#define BL_KONGO_LANGUAGE 'kon\0'
#define BL_KOREAN_LANGUAGE 'kor\0'
#define BL_KOSRAEAN_LANGUAGE 'kos\0'
#define BL_KPELLE_LANGUAGE 'kpe\0'
#define BL_KRU_LANGUAGE 'kro\0'
#define BL_KURUKH_LANGUAGE 'kru\0'
#define BL_KUANYAMA_LANGUAGE 'kua\0'
#define BL_KUMYK_LANGUAGE 'kum\0'
#define BL_KURDISH_LANGUAGE 'kur\0'
#define BL_KUTENAI_LANGUAGE 'kut\0'
#define BL_LADINO_LANGUAGE 'lad\0'
#define BL_LAHNDA_LANGUAGE 'lah\0'
#define BL_LAMBA_LANGUAGE 'lam\0'
#define BL_LAO_LANGUAGE 'lao\0'
#define BL_LATIN_LANGUAGE 'lat\0'
#define BL_LATVIAN_LANGUAGE 'lav\0'
#define BL_LEZGHIAN_LANGUAGE 'lez\0'
#define BL_LINGALA_LANGUAGE 'lin\0'
#define BL_LITHUANIAN_LANGUAGE 'lit\0'
#define BL_MONGO_LANGUAGE 'lol\0'
#define BL_LOZI_LANGUAGE 'loz\0'
#define BL_LETZEBURGESCH_LANGUAGE 'ltz\0'
#define BL_LUBA_LULUA_LANGUAGE 'lua\0'
#define BL_LUBA_KATANGA_LANGUAGE 'lub\0'
#define BL_GANDA_LANGUAGE 'lug\0'
#define BL_LUISENO_LANGUAGE 'lui\0'
#define BL_LUNDA_LANGUAGE 'lun\0'
#define BL_LUO_LANGUAGE 'lus\0'
#define BL_MADURESE_LANGUAGE 'mad\0'
#define BL_MAGAHI_LANGUAGE 'mag\0'
#define BL_MARSHALL_LANGUAGE 'mah\0'
#define BL_MAITHILI_LANGUAGE 'mai\0'
#define BL_MAKASAR_LANGUAGE 'mak\0'
#define BL_MALAYALAM_LANGUAGE 'mal\0'
#define BL_MANDINGO_LANGUAGE 'man\0'
#define BL_AUSTRONESIAN_LANGUAGE 'map\0'
#define BL_MARATHI_LANGUAGE 'mar\0'
#define BL_MASAI_LANGUAGE 'mas\0'
#define BL_MANX_LANGUAGE 'max\0'
#define BL_MANDAR_LANGUAGE 'mdr\0'
#define BL_MENDE_LANGUAGE 'men\0'
#define BL_MIDDLE_IRISH_LANGUAGE 'mga\0'
#define BL_MICMAC_LANGUAGE 'mic\0'
#define BL_MINANGKABAU_LANGUAGE 'min\0'
#define BL_MISCELLANEOUS_LANGUAGE 'mis\0'
#define BL_MACEDONIAN_LANGUAGE 'mkd\0'
#define BL_MON_KHMER_LANGUAGE 'mkh\0'
#define BL_MALAGASY_LANGUAGE 'mlg\0'
#define BL_MALTESE_LANGUAGE 'mlt\0'
#define BL_MANIPURI_LANGUAGE 'mni\0'
#define BL_MANOBO_LANGUAGE 'mno\0'
#define BL_MOHAWK_LANGUAGE 'moh\0'
#define BL_MOLDAVIAN_LANGUAGE 'mol\0'
#define BL_MONGOLIAN_LANGUAGE 'mon\0'
#define BL_MOSSI_LANGUAGE 'mos\0'
#define BL_MAORI_LANGUAGE 'mri\0'
#define BL_MALAY_LANGUAGE 'msa\0'
#define BL_MULTIPLE_LANGUAGE 'mul\0'
#define BL_MUNDA_LANGUAGE 'mun\0'
#define BL_CREEK_LANGUAGE 'mus\0'
#define BL_MARWARI_LANGUAGE 'mwr\0'
#define BL_BURMESE_LANGUAGE 'mya\0'
#define BL_MAYAN_LANGUAGE 'myn\0'
#define BL_AZTEC_LANGUAGE 'nah\0'
#define BL_NORTH_AMERICAN_NATIVE_LANGUAGE 'nai\0'
#define BL_NAURU_LANGUAGE 'nau\0'
#define BL_NAVAJO_LANGUAGE 'nav\0'
#define BL_SOUTH_NDEBELE_LANGUAGE 'nbl\0'
#define BL_NORTH_NDEBELE_LANGUAGE 'nde\0'
#define BL_NDONGA_LANGUAGE 'ndo\0'
#define BL_NEPALI_LANGUAGE 'nep\0'
#define BL_NEWARI_LANGUAGE 'new\0'
#define BL_NIAS_LANGUAGE 'nia\0'
#define BL_NIGER_KORDOFANIAN_LANGUAGE 'nic\0'
#define BL_NIUEAN_LANGUAGE 'niu\0'
#define BL_DUTCH_LANGUAGE 'nld\0'
#define BL_OLD_NORSE_LANGUAGE 'non\0'
#define BL_NORWEGIAN_LANGUAGE 'nor\0'
#define BL_NORTHERN_SOHTO_LANGUAGE 'nso\0'
#define BL_NUBIAN_LANGUAGE 'nub\0'
#define BL_NYANJA_LANGUAGE 'nya\0'
#define BL_NYAMWEZI_LANGUAGE 'nym\0'
#define BL_NYANKOLE_LANGUAGE 'nyn\0'
#define BL_NYORO_LANGUAGE 'nyo\0'
#define BL_NZIMA_LANGUAGE 'nzi\0'
#define BL_OCCITAN_LANGUAGE 'oci\0'
#define BL_OJIBWA_LANGUAGE 'oji\0'
#define BL_ORIYA_LANGUAGE 'ori\0'
#define BL_OROMO_LANGUAGE 'orm\0'
#define BL_OSAGE_LANGUAGE 'osa\0'
#define BL_OSSETIC_LANGUAGE 'oss\0'
#define BL_OTTOMAN_TURKISH_LANGUAGE 'ota\0'
#define BL_OTOMIAN_LANGUAGE 'oto\0'
#define BL_PAPUAN_LANGUAGE 'paa\0'
#define BL_PANGASINAN_LANGUAGE 'pag\0'
#define BL_PAHLAVI_LANGUAGE 'pal\0'
#define BL_PAMPANGA_LANGUAGE 'pam\0'
#define BL_PANJABI_LANGUAGE 'pan\0'
#define BL_PAPIAMENTO_LANGUAGE 'pap\0'
#define BL_PALAUAN_LANGUAGE 'pau\0'
#define BL_OLD_PERSIAN_LANGUAGE 'peo\0'
#define BL_PHILIPPINE_LANGUAGE 'phi\0'
#define BL_PHOENICIAN_LANGUAGE 'phn\0'
#define BL_PALI_LANGUAGE 'pli\0'
#define BL_POLISH_LANGUAGE 'pol\0'
#define BL_POHNPEIAN_LANGUAGE 'pon\0'
#define BL_PORTUGUESE_LANGUAGE 'por\0'
#define BL_PRAKRIT_LANGUAGE 'pra\0'
#define BL_OLD_PROVENCAL_LANGUAGE 'pro\0'
#define BL_PUSHTO_LANGUAGE 'pus\0'
#define BL_QUECHUA_LANGUAGE 'que\0'
#define BL_RAJASTHANI_LANGUAGE 'raj\0'
#define BL_RAPANUI_LANGUAGE 'rap\0'
#define BL_RAROTONGAN_LANGUAGE 'rar\0'
#define BL_ROMANACE_LANGUAGE 'roa\0'
#define BL_RHAETO_ROMANCE_LANGUAGE 'roh\0'
#define BL_ROMANY_LANGUAGE 'rom\0'
#define BL_ROMANIAN_LANGUAGE 'ron\0'
#define BL_RUNDI_LANGUAGE 'run\0'
#define BL_RUSSIAN_LANGUAGE 'rus\0'
#define BL_SANDAWE_LANGUAGE 'sad\0'
#define BL_SANGO_LANGUAGE 'sag\0'
#define BL_SOUTH_AMERICAN_NATIVE_LANGUAGE 'sai\0'
#define BL_SALISHAN_LANGUAGE 'sal\0'
#define BL_SAMARITAN_AMRAMAIC_LANGUAGE 'sam\0'
#define BL_SANSKRIT_LANGUAGE 'san\0'
#define BL_SASAK_LANGUAGE 'sas\0'
#define BL_SANTALI_LANGUAGE 'sat\0'
#define BL_SCOTS_LANGUAGE 'sco\0'
#define BL_SELKUP_LANGUAGE 'sel\0'
#define BL_SEMITIC_LANGUAGE 'sem\0'
#define BL_OLD_IRISH_LANGUAGE 'sga\0'
#define BL_SHAN_LANGUAGE 'shn\0'
#define BL_SIDAMO_LANGUAGE 'sid\0'
#define BL_SINHALESE_LANGUAGE 'sin\0'
#define BL_SIOUAN_LANGUAGE 'sio\0'
#define BL_SINO_TIBETAN_LANGUAGE 'sit\0'
#define BL_SLAVIC_LANGUAGE 'sla\0'
#define BL_SLOVAK_LANGUAGE 'slk\0'
#define BL_SLOVENIAN_LANGUAGE 'slv\0'
#define BL_SAMI_LANGUAGE 'smi\0'
#define BL_SAMOAN_LANGUAGE 'smo\0'
#define BL_SHONA_LANGUAGE 'sna\0'
#define BL_SINDHI_LANGUAGE 'snd\0'
#define BL_SONINKE_LANGUAGE 'snk\0'
#define BL_SOGDIAN_LANGUAGE 'sog\0'
#define BL_SOMALI_LANGUAGE 'som\0'
#define BL_SONGHAI_LANGUAGE 'son\0'
#define BL_SOUTHERN_SOTHO_LANGUAGE 'sot\0'
#define BL_SPANISH_LANGUAGE 'spa\0'
#define BL_ALBANIAN_LANGUAGE 'sqi\0'
#define BL_SARDINIAN_LANGUAGE 'srd\0'
#define BL_SERBIAN_LANGUAGE 'srp\0'
#define BL_SERER_LANGUAGE 'srr\0'
#define BL_NILO_SAHARAN_LANGUAGE 'ssa\0'
#define BL_SWATI_LANGUAGE 'ssw\0'
#define BL_SUKUMA_LANGUAGE 'suk\0'
#define BL_SUNDANESE_LANGUAGE 'sun\0'
#define BL_SUSU_LANGUAGE 'sus\0'
#define BL_SUMERIAN_LANGUAGE 'sux\0'
#define BL_SWAHILI_LANGUAGE 'swa\0'
#define BL_SWEDISH_LANGUAGE 'swe\0'
#define BL_SYRIAC_LANGUAGE 'syr\0'
#define BL_TAHITIAN_LANGUAGE 'tah\0'
#define BL_TAI_LANGUAGE 'tai\0'
#define BL_TAMIL_LANGUAGE 'tam\0'
#define BL_TATAR_LANGUAGE 'tat\0'
#define BL_TELUGU_LANGUAGE 'tel\0'
#define BL_TIMNE_LANGUAGE 'tem\0'
#define BL_TERENO_LANGUAGE 'ter\0'
#define BL_TETUM_LANGUAGE 'tet\0'
#define BL_TAJIK_LANGUAGE 'tgk\0'
#define BL_TAGALOG_LANGUAGE 'tgl\0'
#define BL_THAI_LANGUAGE 'tha\0'
#define BL_TIGRE_LANGUAGE 'tig\0'
#define BL_TIGRINYA_LANGUAGE 'tir\0'
#define BL_TIV_LANGUAGE 'tiv\0'
#define BL_TOKELAU_LANGUAGE 'tkl\0'
#define BL_TLINGIT_LANGUAGE 'tli\0'
#define BL_TAMASHEK_LANGUAGE 'tmh\0'
#define BL_TONGA_NYASA_LANGUAGE 'tog\0'
#define BL_TONGA_ISLANDS_LANGUAGE 'ton\0'
#define BL_TOK_PISIN_LANGUAGE 'tpi\0'
#define BL_TSIMSHIAN_LANGUAGE 'tsi\0'
#define BL_TSWANA_LANGUAGE 'tsn\0'
#define BL_TSONGA_LANGUAGE 'tso\0'
#define BL_TURKMEN_LANGUAGE 'tuk\0'
#define BL_TUMBUKA_LANGUAGE 'tum\0'
#define BL_TURKISH_LANGUAGE 'tur\0'
#define BL_ALTAIC_LANGUAGE 'tut\0'
#define BL_TUVALU_LANGUAGE 'tvl\0'
#define BL_TWI_LANGUAGE 'twi\0'
#define BL_TUVINIAN_LANGUAGE 'tyv\0'
#define BL_UGARITIC_LANGUAGE 'uga\0'
#define BL_UIGHUR_LANGUAGE 'uig\0'
#define BL_UKRAINIAN_LANGUAGE 'ukr\0'
#define BL_UMBUNDU_LANGUAGE 'umb\0'
#define BL_UNDETERMINED_LANGUAGE 'und\0'
#define BL_URDU_LANGUAGE 'urd\0'
#define BL_UZBEK_LANGUAGE 'uzb\0'
#define BL_VAI_LANGUAGE 'vai\0'
#define BL_VENDA_LANGUAGE 'ven\0'
#define BL_VIETNAMESE_LANGUAGE 'vie\0'
#define BL_VOLAPUK_LANGUAGE 'vol\0'
#define BL_VOTIC_LANGUAGE 'vot\0'
#define BL_WAKASHAN_LANGUAGE 'wak\0'
#define BL_WALAMO_LANGUAGE 'wal\0'
#define BL_WARAY_LANGUAGE 'war\0'
#define BL_WASHO_LANGUAGE 'was\0'
#define BL_SORBIAN_LANGUAGE 'wen\0'
#define BL_WOLOF_LANGUAGE 'wol\0'
#define BL_XHOSA_LANGUAGE 'xho\0'
#define BL_UK_ENGLISH_LANGUAGE 'xxuk\0'
#define BL_YAO_LANGUAGE 'yao\0'
#define BL_YAPESE_LANGUAGE 'yap\0'
#define BL_YIDDISH_LANGUAGE 'yid\0'
#define BL_YORUBA_LANGUAGE 'yor\0'
#define BL_YUPIK_LANGUAGE 'ypk\0'
#define BL_ZAPOTEC_LANGUAGE 'zap\0'
#define BL_ZENAGA_LANGUAGE 'zen\0'
#define BL_ZHUANG_LANGUAGE 'zha\0'
#define BL_CHINESE_LANGUAGE 'zho\0'
#define BL_ZANDE_LANGUAGE 'znd\0'
#define BL_ZULU_LANGUAGE 'zul\0'
#define BL_ZUNI_LANGUAGE 'zun\0'

/* Failure */
#define	BL_MISSING_STRING		0x80000000
#define 	BL_NODICT_STRING		0x80000001

/* Menu Titles */
#define	BL_FILE_STRING		0x80010000
#define	BL_EDIT_STRING		0x80010001
#define	BL_FONT_STRING		0x80010002
#define	BL_SIZE_STRING		0x80010003
#define	BL_STYLE_STRING		0x80010004
#define	BL_TOOLS_STRING		0x80010005
#define	BL_WINDOW_STRING		0x80010006
#define	BL_HELP_STRING		0x80010007
#define	BL_ADDON_STRING		0x80010008
#define	BL_COLOR_STRING		0x80010009
#define	BL_SOUND_STRING		0x8001000A
#define	BL_APP_LANG_STRING		0x8001000B

/* Menu Items */
#define	BL_NEW_STRING			0x80020000
#define	BL_OPEN_STRING		0x80020001
#define	BL_CLOSE_STRING		0x80020002
#define	BL_SAVE_STRING		0x80020003
#define	BL_SAVEAS_STRING		0x80020004
#define	BL_SAVECOPY_STRING		0x80020005
#define	BL_REVERT_STRING		0x80020006
#define	BL_PRINT_STRING		0x80020007
#define	BL_PAGESETUP_STRING	0x80020008
#define	BL_ABOUT_STRING		0x80020009
#define	BL_APPHELP_STRING		0x8002000A
#define	BL_QUIT_STRING		0x8002000B
#define	BL_UNDO_STRING		0x8002000C
#define	BL_UNDOACTION_STRING	0x8002000D
#define	BL_CUT_STRING			0x8002000E
#define	BL_COPY_STRING		0x8002000F
#define	BL_PASTE_STRING		0x80020010
#define	BL_CLEAR_STRING		0x80020011
#define	BL_SELECTALL_STRING	0x80020012
#define	BL_SETTINGS_STRING		0x80020013
#define	BL_FIND_STRING		0x80020014
#define	BL_FINDNEXT_STRING		0x80020015
#define	BL_REPLACE_STRING		0x80020016
#define	BL_REPLACEALL_STRING	0x80020017
#define	BL_REPLACEFIND_STRING	0x80020018
#define	BL_STACK_STRING		0x80020019
#define	BL_TILE_STRING		0x8002001A
#define	BL_GETINFO_STRING		0x8002001B
#define	BL_REDO_STRING		0x8002001C
#define	BL_REDOACTION_STRING	0x8002001D

/* Buttons */
#define	BL_ADD_STRING			0x80030000
#define	BL_REMOVE_STRING		0x80030001
#define	BL_OK_STRING		0x80030002
#define	BL_CANCEL_STRING		0x80030003
#define	BL_CONTINUE_STRING		0x80030004
#define	BL_DONTSAVE_STRING		0x80030005
#define	BL_YES_STRING			0x80030006
#define	BL_NO_STRING			0x80030007

/* Messages */
#define	BL_WANTTOSAVE_STRING	0x80040000
#define	BL_RIGHTSRES_STRING	0x80040001

/* Blithe Strings */
#define BLITHE_INSTR_STRING		0x80050001
#define BLITHE_LANGUAGE_STRING	0x80050002
#define BLITHE_NOTIFY_STRING	0x80050003
#define BLITHE_SETTING_STRING	0x80050004

#endif
